<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Cta_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'cta_widget';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Cta Widget', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'cta_widget',
			[
				'label' => esc_html__( 'Cta Widget', 'dogri-elementor' ),
			]
		);		
		

		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'dogri-elementor' ),
			]
		);


		$this->add_control(
			'bgimg',
			[
				'label' => esc_html__('Background image 1', 'dogri-elementor'),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);	

		$this->add_control(
			'bgimg1',
			[
				'label' => esc_html__('Background image 2 ', 'dogri-elementor'),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);	

		$this->add_control(
			'bgimg2',
			[
				'label' => esc_html__('Background image 3', 'dogri-elementor'),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);	

		$this->add_control(
			'bgimg3',
			[
				'label' => esc_html__('Background image 4', 'dogri-elementor'),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);	


		
	$this->add_control(
		'bttn',
			[
				'label'       => __( 'Button', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => esc_html__( 'Enter your Button Title', 'dogri-elementor' ),
				'default' => esc_html__('Read More', 'dogri-elementor'),
			]
		);	


	$this->add_control(
			'btnlink',
			[
			'label' => __( 'Button Url', 'dogri-elementor' ),
			'type' => Controls_Manager::URL,
			'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
			'show_external' => true,
			'default' => [
				'url' => '',
				'is_external' => true,
				'nofollow' => true,
			],
			
		]
		);


		
		$this->end_controls_section();

		

	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//put the js code under this line 



//put the code above the line 

  });
</script>';


?>

<!-- cta-2-section -->
<section class="cta-2-section position-relative">   
    <div class="cta-out-shape" style="background-image: url(<?php echo wp_get_attachment_url($settings['bgimg']['id']);?>);"></div> 
    <div class="dogri-container">
        <div class="cta-container position-relative">
            <div class="cta-map" style="background-image: url(<?php echo wp_get_attachment_url($settings['bgimg1']['id']);?>);"></div>
            <div class="cta-shape" style="background-image: url(<?php echo wp_get_attachment_url($settings['bgimg2']['id']);?>);"></div>
            <div class="cta-bg" style="background-image: url(<?php echo wp_get_attachment_url($settings['bgimg3']['id']);?>);"></div>
            <div class="cta-inner">
                <div class="title-box">
                    <h2 class="sec-title"><?php echo $settings['title'];?></h2>                  
                </div>
                <div class="cta-2-btn-box">
                    <a href="<?php echo esc_url($settings['btnlink']['url']);?>" class="theme-btn btn-style-one btn-style-two">
                        <span class="txt"><?php echo $settings['bttn'];?></span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- cta-2-section-end -->


             
		<?php 
	}


}